/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public class ViewAreaRenderer {
    public static void renderPortalArea(Portal portal, class_243 fogColor, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean doFaceCulling, boolean doModifyColor, boolean doModifyDepth, boolean doClip) {
        if (doFaceCulling) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
        if (portal.isFuseView() && IPGlobal.maxPortalLayer != 0) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else if (!doModifyColor) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (doModifyDepth) {
            if (portal.isFuseView()) {
                GlStateManager._depthMask((boolean)false);
            } else {
                GlStateManager._depthMask((boolean)true);
            }
        } else {
            GlStateManager._depthMask((boolean)false);
        }
        boolean shouldReverseCull = PortalRendering.isRenderingOddNumberOfMirrors();
        if (shouldReverseCull) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
        if (doClip) {
            if (PortalRendering.isRendering()) {
                FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelViewMatrix, 0.0);
            }
        } else {
            FrontClipping.disableClipping();
        }
        GlStateManager._enableDepthTest();
        CHelper.enableDepthClamp();
        class_5944 shader = MyRenderHelper.portalAreaShader;
        RenderSystem.setShader(() -> shader);
        shader.field_29470.method_1250(modelViewMatrix);
        shader.field_29471.method_1250(projectionMatrix);
        FrontClipping.updateClippingEquationUniformForCurrentShader(false);
        shader.method_34586();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(fogColor, portal, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.method_34585();
        GlStateManager._enableCull();
        CHelper.disableDepthClamp();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
        if (shouldReverseCull) {
            MyRenderHelper.recoverFaceCulling();
        }
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
        }
        CHelper.checkGlError();
    }

    public static void buildPortalViewAreaTrianglesBuffer(class_243 fogColor, Portal portal, class_243 cameraPos, float partialTick) {
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        class_243 originRelativeToCamera = portal.getOriginPos().method_1020(cameraPos);
        TriangleConsumer vertexOutput = (p0x, p0y, p0z, p1x, p1y, p1z, p2x, p2y, p2z) -> {
            bufferBuilder.method_22912((float)p0x, (float)p0y, (float)p0z).method_22915((float)fogColor.field_1352, (float)fogColor.field_1351, (float)fogColor.field_1350, 1.0f);
            bufferBuilder.method_22912((float)p1x, (float)p1y, (float)p1z).method_22915((float)fogColor.field_1352, (float)fogColor.field_1351, (float)fogColor.field_1350, 1.0f);
            bufferBuilder.method_22912((float)p2x, (float)p2y, (float)p2z).method_22915((float)fogColor.field_1352, (float)fogColor.field_1351, (float)fogColor.field_1350, 1.0f);
        };
        portal.renderViewAreaMesh(originRelativeToCamera, vertexOutput);
        class_286.method_43437((class_9801)Objects.requireNonNull(bufferBuilder.method_60794()));
    }

    public static void outputTriangle(TriangleConsumer vertexOutput, class_243 center, class_243 localXAxis, class_243 localYAxis, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        vertexOutput.accept(center.field_1352 + p0x * localXAxis.method_10216() + p0y * localYAxis.method_10216(), center.field_1351 + p0x * localXAxis.method_10214() + p0y * localYAxis.method_10214(), center.field_1350 + p0x * localXAxis.method_10215() + p0y * localYAxis.method_10215(), center.field_1352 + p1x * localXAxis.method_10216() + p1y * localYAxis.method_10216(), center.field_1351 + p1x * localXAxis.method_10214() + p1y * localYAxis.method_10214(), center.field_1350 + p1x * localXAxis.method_10215() + p1y * localYAxis.method_10215(), center.field_1352 + p2x * localXAxis.method_10216() + p2y * localYAxis.method_10216(), center.field_1351 + p2x * localXAxis.method_10214() + p2y * localYAxis.method_10214(), center.field_1350 + p2x * localXAxis.method_10215() + p2y * localYAxis.method_10215());
    }

    @Deprecated
    private static void generateTriangleForNormalShape(TriangleConsumer vertexOutput, Portal portal, class_243 posInPlayerCoordinate) {
        double w = Math.min(portal.getWidth(), 23333.0);
        double h = Math.min(portal.getHeight(), 23333.0);
        class_243 localXAxis = portal.getAxisW().method_1021(w / 2.0);
        class_243 localYAxis = portal.getAxisH().method_1021(h / 2.0);
        ViewAreaRenderer.outputFullQuad(vertexOutput, posInPlayerCoordinate, localXAxis, localYAxis);
    }

    @Deprecated
    private static void generateTriangleForGlobalPortal(TriangleConsumer vertexOutput, Portal portal, class_243 portalOriginLocal) {
        double distance;
        class_243 cameraPosFromPortalOrigin = portalOriginLocal.method_1021(-1.0);
        class_243 cameraPosFromPortalOriginProjected = portal.getLocalVecProjectedToPlane(cameraPosFromPortalOrigin);
        class_243 localCenter = portalOriginLocal.method_1019(cameraPosFromPortalOriginProjected);
        double r = class_310.method_1551().field_1690.method_38521() * 16 - 16;
        if (TransformationManager.isIsometricView) {
            r *= 2.0;
        }
        if ((distance = Math.abs(cameraPosFromPortalOrigin.method_1026(portal.getNormal()))) > 200.0) {
            r = r * 200.0 / distance;
        }
        class_243 localXAxis = portal.getAxisW().method_1021(r);
        class_243 localYAxis = portal.getAxisH().method_1021(r);
        ViewAreaRenderer.outputFullQuad(vertexOutput, localCenter, localXAxis, localYAxis);
    }

    public static void outputFullQuad(TriangleConsumer vertexOutput, class_243 posInPlayerCoordinate, class_243 localXAxis, class_243 localYAxis) {
        ViewAreaRenderer.outputTriangle(vertexOutput, posInPlayerCoordinate, localXAxis, localYAxis, 1.0, 1.0, -1.0, 1.0, 1.0, -1.0);
        ViewAreaRenderer.outputTriangle(vertexOutput, posInPlayerCoordinate, localXAxis, localYAxis, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0);
    }
}

